function JMessageDialog(owner, parent, name, type, message, buttons, actions, rect)
{
	var self = this;
	var _rendered = false;
	var _disposed = false;

	this.initialize (owner, parent, name, null, null, rect);

	this.isForm   = true;
	this.type     = new Number(type);
	this.message  = message;
	this.buttons  = new Number(buttons);
	this.actions  = actions;
	this.methods  = (cmRender | cmLoad);
	this.caption  = this.owner.localize(((this.type == mtInformation) ? "capInformation" : ((this.type == mtQuestion) ? "capQuestion" : ((this.type == mtWarning) ? "capWarning" : "capError"))));
	this.icon     = ((this.type == mtInformation) ? "info" : ((this.type == mtQuestion) ? "question" : ((this.type == mtWarning) ? "warning" : "error")));
	this.memo     = null;
	this.local    = null;
	this.previous = null;

	this.render  = render;
	this.load    = load;
	this.close   = close;
	this.isRendered = isRendered;
	this.dispose = dispose;

	this.owner.addImage("close-icon", "close.gif", "form");
	this.owner.addImage(this.icon, this.icon + ".gif", "form");

	this.rect.normalize(this.owner.getDocument().body);

	this.owner.activeForm = this;

	function render(fs)
	{
		self.previous = self.owner.getObject(self.owner.activeForm);
		//self.owner.activeForm = self.name;

		self.local = self.owner.registerObject(self.name, self.name + "_local", new JDataset(self.owner, self.name, self.name + "_local", "", "", dfNone));
		self.local.addField(new JField("msg", "", ftMemo, "", ffReadOnly));
		self.local.load("add", "", "msg=" + self.message + "%17", rsUnchanged, rfNone, true);

		self.memo = self.owner.registerObject(self.name + "_memo", new JEdit(self.owner, self.name, self.name + "_memo", self.local, "msg", ";;240;50", etMemo, null));
		self.addControl(memo);

		fs.append('<div class="form" id="' + self.name + '" style="' + self.rect + '">');
		fs.append(   '<span class="form_dragbar" id="' + self.name + '_dragbar" style="background-color: activecaption; height: ' + fmDragbarHeight + 'px">');
		fs.append(     '<table border="0" cellpadding="0">');
		fs.append(       '<tr valign="middle" style="height: ' + fmDragbarHeight + 'px">');
		fs.append(         '<td class="form_titlebar" id="' + self.name + '"_titlebar" width="100%">' + self.caption + '</td>');
		fs.append(         '<td><img class="form_bordericon" id="' + self.name + '_closeicon" src="' + self.owner.images['close-icon'].src + '" /></td>');
		fs.append(       '</tr>');
		fs.append(     '</table>');
		fs.append(   '</span>');
		fs.append(   '<div class="form_inlet" id="' + self.name + '_inlet" align="center" style="top: "' + (fmDragbarHeight + fmBorderWidth) + 'px; height: ' + (self.rect.height - fmDragbarHeight - 3 * fmBorderWidth) + 'px; width: ' + (self.rect.width - 2 * fmBorderWidth) + 'px">');
		fs.append(     '<table width="100%" height="65%">');
		fs.append(       '<tr>');
		fs.append(         '<td height="100%" valign="middle"><img src="' + self.owner.images[self.icon].src + '" /></td>');
		fs.append(         '<td height="100%" valign="middle">');
		self.memo.render(fs);
		fs.append(         '</td>');

		fs.append(       '</tr>');
		fs.append(     '</table>');
		fs.append(     '<table width="100%" height="30%">');
		fs.append(       '<tr>');


		var btn = null;

		if (utils.inSet(mbYes, self.buttons))
		{
			btn = self.owner.registerObject(self.name + "_Yes", new JButton(self.owner, self.name, self.name + "_Yes", self.owner.localize("capYes"), 1, ";;60;21", (self.actions != null) ? self.actions[mbYes] : raCloseParent, null));
		}

		if (utils.inSet(mbNo, self.buttons))
		{
			btn = self.owner.registerObject(self.name + "_No", new JButton(self.owner, self.name, self.name + "_No", self.owner.localize("capNo"), 1, ";;60;21", (self.actions != null) ? self.actions[mbNo] : raCloseParent, null));
		}

		if (utils.inSet(mbOK, self.buttons))
		{
			btn = self.owner.registerObject(self.name + "_OK", new JButton(self.owner, self.name, self.name + "_OK", self.owner.localize("capOK"), 1, ";;60;21", (self.actions != null) ? self.actions[mbOK] : raCloseParent, null));
		}

		if (utils.inSet(mbCancel, self.buttons))
		{
			btn = self.owner.registerObject(self.name + "_Cancel", new JButton(self.owner, self.name, self.name + "_Cancel", self.owner.localize("capCancel"), 1, ";;60;21", (self.actions != null) ? self.actions[mbCancel] : raCloseParent, null));
		}

		if (utils.inSet(mbHelp, self.buttons))
		{
			btn = self.owner.registerObject(self.name + "_Help", new JButton(self.owner, self.name, self.name + "_Help", self.owner.localize("capHelp"), 1, ";;60;21", (self.actions != null) ? self.actions[mbHelp] : raCloseParent, null));
		}

		if (btn != null)
		{
			fs.append('<td align="center">');
			btn.render(fs);
			fs.append('</td>');

//			btn.$$().click = buttonClick;
			self.addControl(btn);
		}

		fs.append(       '</tr>');
		fs.append(     '</table>');
		fs.append(   '</div>');
		fs.append( '</div>');
	}

	function load()
	{
		self.owner.getDocument().body.appendChild(self.$$());

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmLoad, control.methods))
				control.load();
		}, self);

		self.owner.splash(true);
		self.owner.setSplashInfo('');
	}

	function isRendered()
	{
	  return _rendered;
	}

	function close(e)
	{
		self.owner.splash(false);
		self.$$().style.display = 'none';

		var elem = utils.getEventElement(e);
		switch (elem.id)
		{
			case self.name + "_Yes":
				break;
		}

		self.owner.unregisterObject(self.name);
		self.dispose();
	}

	function dispose()
	{
		if (_disposed)
			return;

		self.local.dispose();
		self.local = null;
		self.disposeChildren();

		if (self.$$().parentNode != null)
			self.$$().parentNode.removeChild(self.$$());

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JMessageDialog.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();